/* 
 * File: I2C.c
 * Author: LaV
 * Comments:
 * Revision history: 1
 */
#include "I2C.h"

void I2C_Idle(){
    while ((SSPSTAT & 0x04) || (SSPCON2 & 0x1F)); //проверка состояния линии  
}
void I2C_Start(){    
    SSPCON2bits.SEN = 1;//формирование стартового бита
    while (SEN==1);   
}
void I2C_ReStart(){
    SSPCON2bits.RSEN=1;
    while(RSEN==1);//формирование повторного стартового бита
}
void I2C_Stop(){
    I2C_Idle();
    SSPCON2bits.PEN=1;
    while(PEN==1);//Формирование стопового бита
}
void I2C_NotAck(){
    SSPCON2bits.ACKDT=1, SSPCON2bits.ACKEN=1;
    while (SSPCON2bits.ACKEN);//подтверждение не формируется
}
void I2C_AckPoll(){//Запрос готовности микросхемы             
    I2C_Start();
    I2C_Idle();
    SSPBUF = 0b10100000;//control byte:1010+000(адресс микросхемы)+0(запись))
    while(BF == 1);//Buffer flag
    I2C_Idle();    
    I2C_Stop(); 
    if(ACKSTAT == 1)err_ack = 1;
    else err_ack = 0;
}
void I2C_AckWait(){ //ожидание готовности slave-микросхемы
    if(err_ack == 1){
        for(char i = 0; i < 100; i++){
        I2C_AckPoll();
        if(err_ack == 0) break;
        }
    }  
}
void I2C_AckChek(){ //проверка приема slave-микросхемой
    err_ack=0;
    if(ACKSTAT==0) err_ack=0;
    else err_ack = 1;    
}
void I2C_Write_byte(unsigned char h_addr, unsigned char l_addr, unsigned char data_I2C){//Запись 1-го байта
        GIE = 0;
        I2C_Start();
        I2C_Idle();
        SSPBUF = 0b10100000;//control byte:1010+000(адресс микросхемы)+0(запись))
        while(BF == 1);//Buffer flag 
        I2C_AckChek(); I2C_Idle(); 
        SSPBUF = h_addr;//hight address
        while(BF == 1);
        I2C_AckChek();I2C_Idle(); 
        SSPBUF = l_addr;//low address
        while(BF == 1);
        I2C_AckChek();
        I2C_Idle(); 
        SSPBUF = data_I2C;//data 
        while(BF == 1);
        I2C_AckChek();I2C_Idle();
        I2C_Stop();
        GIE = 1;//!!!Цикл записи до 5мс.!!!
    }
void I2C_Delete_page(unsigned char h_addr, unsigned char l_addr){//удалить(перезаписать 0xFF) страницу (128 байт)     
        GIE = 0;
        I2C_Start();
        I2C_Idle();
        SSPBUF = 0b10100000;//control byte:1010+000(адресс микросхемы)+0(запись))
        while(BF == 1);//Buffer flag 
        I2C_AckChek(); I2C_Idle();       
        SSPBUF = h_addr;//hight address
        while(BF == 1);
        I2C_AckChek();I2C_Idle(); 
        SSPBUF = l_addr;//low address
        while(BF == 1);
        I2C_AckChek();
        I2C_Idle(); 
        for(unsigned char i = 0; i < 127; i++){
            SSPBUF = 0xFF;//data 
            while(BF == 1);
            I2C_AckChek();I2C_Idle();            
        }
        I2C_Stop();
        GIE = 1;//!!!Цикл записи до 5мс.!!!
    }
void I2C_Delete_all(){
//стереть микросхему полностью
    for(unsigned char i = 0; i < 255; i++){
        I2C_AckPoll();//проверка готовности микросхемы
        I2C_AckWait();//если занята, - ждем  
        I2C_Delete_page(i,0);//удалить младшую страницу (адрес i,0x00)
        
        I2C_AckPoll();//проверка готовности микросхемы
        I2C_AckWait();//если занята, - ждем  
        I2C_Delete_page(i,128); //удалить старшую страницу (адрес i,128)       
    }    
}
void I2C_Write_3byte(unsigned char h_addr, unsigned char l_addr, unsigned char data_I2C, unsigned char data1_I2C, unsigned char data2_I2C){//Запись 3-х байт
        GIE = 0;
        I2C_Start();
        I2C_Idle();
        SSPBUF = 0b10100000;//control byte:1010+000(адресс микросхемы)+0(запись))
        while(BF == 1);//Buffer flag 
        I2C_AckChek();I2C_Idle(); 
        SSPBUF = h_addr;//hight address
        while(BF == 1);
        I2C_AckChek();I2C_Idle(); 
        SSPBUF = l_addr;//low address
        while(BF == 1);
        I2C_AckChek();I2C_Idle(); 
        SSPBUF = data_I2C;//data 
        while(BF == 1);
        I2C_AckChek();I2C_Idle(); 
        SSPBUF = data1_I2C;//data 
        while(BF == 1);
        I2C_AckChek();I2C_Idle(); 
        SSPBUF = data2_I2C;//data 
        while(BF == 1);
        I2C_Stop();
        GIE = 1;//!!!Цикл записи до 5мс.!!!
    }
void I2C_Write(unsigned char temp_I2C){//функция записи       
    I2C_Idle(); 
    SSPBUF = temp_I2C;//hight address
    while(BF == 1);
    I2C_AckChek();
}
unsigned char I2C_Read(unsigned char h_addr, unsigned char l_addr){
      GIE = 0;
      I2C_Start();
      I2C_Idle();
      SSPBUF = 0b10100000;//code byte
      while(BF == 1); 
      I2C_Idle(); 
      SSPBUF = h_addr;//h address
      while(BF == 1);
      I2C_Idle(); 
      SSPBUF = l_addr;//l address
      while(BF == 1);
      I2C_Idle();
      
      I2C_ReStart();//read
      SSPBUF = 0b10100001;//control byte:1010+000(адресс микросхемы)+1(запись))
      while(BF == 1); 
      I2C_Idle(); 
      ACKDT = 1;
      RCEN = 1; 
      while(BF==1);
      while(RCEN==1);      
      I2C_NotAck();      
      I2C_Stop;
      ACKDT = 0;
      GIE = 1;
      return SSPBUF;
    }
void I2C_Read_3byte(unsigned char h_addrC, unsigned char l_addr){
      GIE = 0;
      I2C_Start();
      I2C_Idle();
      SSPBUF = 0b10100000;//code byte
      while(BF == 1); 
      I2C_Idle(); 
      SSPBUF = h_addr;//h address
      while(BF == 1);
      I2C_Idle(); 
      SSPBUF = l_addr;//l address
      while(BF == 1);
      I2C_Idle();
      
      I2C_ReStart();//read
      SSPBUF = 0b10100001;//control byte:1010+000(адресс микросхемы)+1(запись))
      while(BF == 1); 
      I2C_Idle(); 
      ACKDT = 0;
      RCEN = 1; 
      while(BF==1); while(RCEN==1);
      data_I2C = SSPBUF; //читаем 1-байт данных
      ACKEN = 1; while(ACKEN==1); //формирование подтверждения приема мастером
           
      RCEN = 1;
      while(BF==1); while(RCEN==1);
      data1_I2C = SSPBUF; //читаем 2-й байт данных
      ACKEN=1; while(ACKEN==1);
      
      RCEN = 1;
      while(BF==1); while(RCEN==1);
      data2_I2C = SSPBUF;//читаем 3-й байт данных
      
      I2C_NotAck();      
      I2C_Stop;
      ACKDT = 0;
      GIE = 1;     
    }
void I2C_card_search_p(void){
//постраничный поиск
    GIE = 0; ////Вариант поиска, чтением по странице (128 байт за раз).
    unsigned char h = 0; int l = 0; card_found = 0;   
    while(h <= h_addr && l <= l_addr){
      I2C_AckPoll(); I2C_AckWait();      
      I2C_Start();
      I2C_Idle();
      SSPBUF = 0b10100000;//code byte
      while(BF == 1); 
      I2C_Idle(); 
      SSPBUF = h;//h address
      while(BF == 1);
      I2C_Idle(); 
      SSPBUF = l;//l address
      while(BF == 1);
      I2C_Idle();
      
      I2C_ReStart();
      SSPBUF = 0b10100001;//control byte:1010+000(адресс микросхемы)+1(запись))
      while(BF == 1); 
      I2C_Idle(); 
      ACKDT = 0;
      for(int i = 0; i < 128; i++){
          RCEN = 1; 
          while(BF==1); while(RCEN==1);
          data_I2C = SSPBUF; //читаем 1-байт данных
          ACKEN = 1; while(ACKEN==1); //формирование подтверждения приема мастером
           
          RCEN = 1;
          while(BF==1); while(RCEN==1);
          data1_I2C = SSPBUF; //читаем 2-й байт данных
          ACKEN=1; while(ACKEN==1);
       
          RCEN = 1;
          while(BF==1); while(RCEN==1);
          data2_I2C = SSPBUF;//читаем 3-й байт данных
      
          if(data_I2C == fcode && data1_I2C == id_h && data2_I2C == id_l){
              card_found = 1;
              break; //если карта найдена, выходим
          }
          ACKEN=1; while(ACKEN==1);
      }      
      l = l +128;
      if(l == 256) l = 0, h++;      
      I2C_NotAck();      
      I2C_Stop;
      ACKDT = 0;
      if(card_found == 1) break;//если карта найдена, выходим
    }
      GIE = 1;     
}
void I2C_card_search(void){
//поиск, чтением по 3 байта
    GIE = 0;//Вариант поиска, чтением по 3 байта.
    card_found = 0;//поиск карты в I2C EEPROM    
    unsigned char h = 0; unsigned char l = 0;    
    while(h <= h_addr && l <= l_addr){
        I2C_AckPoll(); I2C_AckWait();
        I2C_Read_3byte(h, l);        
        if(data_I2C == fcode && data1_I2C == id_h && data2_I2C == id_l){
            card_found = 1;
            break;
        }
        l = l+3; 
        if (l == 255) {l = 0; h++;}
    }
    GIE = 1;    
}
